import os
from flask import Flask


def create_app(test_config=None):
    # create and configure the app
    app = Flask(__name__, instance_relative_config=True, template_folder='templates')
    app.config.from_mapping(
        SECRET_KEY='canister-unveiled-vigorous',
        WINRAR_EXE_DIRECTORY='C:/Program Files/WinRAR/',
        BAROTRAUMA_SAVEDATA_DIRECTORY='C:/Users/[改成你的用户名]/AppData/Local/Daedalic Entertainment GmbH/'
    )
    from . import BarotraumaSaveData
    app.register_blueprint(BarotraumaSaveData.bp_SaveData)
    if test_config is None:
        # load the instance config, if it exists, when not testing
        app.config.from_pyfile('config.py', silent=True)
    else:
        # load the test config if passed in
        app.config.from_mapping(test_config)

    # ensure the instance folder exists
    try:
        os.makedirs(app.instance_path)
    except OSError:
        pass

    # a page to test connectivity
    @app.route('/hello')
    def hello():
        return 'Hello, 欢迎使用Barotrauma远程存档备份器!'

    return app
