import datetime
import subprocess
import os
from flask import (
    Blueprint, flash, g, redirect, render_template, request, session, url_for, current_app, send_from_directory)

from werkzeug.security import check_password_hash, generate_password_hash

bp_SaveData = Blueprint('BarotraumaSaveData', __name__,
                        url_prefix='/BarotraumaSaveData')


@bp_SaveData.route('/', methods=['GET', 'POST'])
def ListSaveFile():
    if request.method == 'GET':
        try:
            list_dir = os.listdir(
                current_app.config['BAROTRAUMA_SAVEDATA_DIRECTORY'])
        except Exception:
            flash(str(Exception))
        tPresentDirectory = (
            current_app.config['BAROTRAUMA_SAVEDATA_DIRECTORY'] + "Barotrauma/").replace("WiiGe", "这是当前账户的用户名")
        return render_template('index.html', list_dir=list_dir, present_dir=tPresentDirectory)
    else:
        if request.form.get('BackUpSaveFile') == "发射潜艇!再来一局!":
            return redirect(url_for('BarotraumaSaveData.MakeSaveFile_RAR'))
        elif request.form.get('DownloadLatestSaveFile') == "把船拿来,让我看看!(震声)":
            return redirect(url_for('BarotraumaSaveData.LatestSaveFile_Download'))
        else:
            return redirect(url_for('BarotraumaSaveData.ListSaveFile'))


@bp_SaveData.route('/save', methods=['GET'])
def MakeSaveFile_RAR():
    fileName = "Barotrauma_" + \
        str(datetime.datetime.now().strftime('%Y-%m-%d_%H.%M.%S.%f'))+".rar"
    MakeRARFile(current_app.config['BAROTRAUMA_SAVEDATA_DIRECTORY'], fileName)
    return redirect(url_for('BarotraumaSaveData.ListSaveFile'))


def MakeRARFile(compressTargetPath, compressFileName):
    SavePathString = compressTargetPath + compressFileName
    print(SavePathString)

    TargetPathString = compressTargetPath + "Barotrauma/"
    print(TargetPathString)

    RARExePathString = current_app.config['WINRAR_EXE_DIRECTORY'] + "Rar.exe"
    print(RARExePathString)

    subprocess.run([RARExePathString, "a", "-r", "-ep1", "-m5",
                   SavePathString, TargetPathString])


@bp_SaveData.route('/download', methods=['GET'])
def LatestSaveFile_Download():
    try:
        list_dir = os.listdir(
            current_app.config['BAROTRAUMA_SAVEDATA_DIRECTORY'])
        list_dir.sort(key=lambda x: int(x[:-4]))
    except Exception:
        flash(str(Exception))
    if len(list_dir) > 1:
        temp_filePath = current_app.config['BAROTRAUMA_SAVEDATA_DIRECTORY']+ list_dir[-1]
        print(temp_filePath)
    else:
        MakeSaveFile_RAR()
        LatestSaveFile_Download()
    return send_from_directory(directory = current_app.config['BAROTRAUMA_SAVEDATA_DIRECTORY'], path= list_dir[-1], as_attachment=True)
